$(document).ready(function(){
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];


    // Hide message
    function hide_message(){
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

    // Show loading message
    function show_loading_message(){
        $('#loading_container').show();
    }
    // Hide loading message
    function hide_loading_message(){
        $('#loading_container').hide();
    }

    // Show lightbox
    function show_lightbox(){
        if (window.innerWidth < 768){
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
            yloc = yloc - 40;
            $('.lightbox_container').css('top',yloc+'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
    }
    // Hide lightbox
    function hide_lightbox(){
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }


    /*
     * EVENT HANDLERS
     */

    // Hide iPad keyboard
    function hide_ipad_keyboard(){
        document.activeElement.blur();
        $('input').blur();
    }


    $('#activeonly').change(function () {
        $('#table_respondents').DataTable().ajax.reload( null, true);
    });


    // on page load, if value was passed in then load survey

    if ($('#surveys').val() != '#'){
        loadSurvey();
    }

    function loadSurvey(){
        var dist = $(window).height() - $('#survey_panel').offset().top - 50;
        $('#survey_frame').html('<iframe src="'+  $('#surveys option:selected').val() +'" width="100%" height="'+ dist +'" seamless=""></iframe>');
    }

    $('#surveys').change(function () {
        if ($('#surveys').val() != '#'){
            loadSurvey();
        }
    });

    $(document).on('click','#ext_survey_link', function(e){
        e.preventDefault();
        var url = $('#surveys option:selected').val();
        if (url != '#'){
            window.open(url,'_blank');
        }
    });


    function refreshSurveyList(){
        var request = $.ajax({
            // url:          './includes/' + thisdir + '/getsurveydata.php?job=get_resp_surveys',
            url: '/' + subdir + '/user_round/get_user_surveys',
            cache:        false,
            data:         'id=1',
            dataType:     'json',
            contentType:  'application/json; charset=utf-8',
            type:         'get'
        });
        request.done(function(output){
            if (output.result == 'success'){
                var html = "<option value=\"#\" >Select a survey</option>"; //"<option value=\"0\" selected=\"selected\">All</option>";
                $.each(output.data, function(key, val){
                    html += "<option value="+val["url"]+">"+val["participant_name"]+ ": "+ val["survey_name"]+"</option>";

                });
                $('#surveys').html(html);

            } else {
                // show_message('Information request failed', 'warning');
            }
        });
    }

});
