var show_message;

$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    // var dir = params[1] + '/' + params[2];

    var countdown = $('#countdown_val').val();

    //send the token
    if ($('#mfa_sent').val() == 0)  {
        send_token();
    }

    $(document).on('click', '#login_token_submit', function () {
        event.preventDefault();
        if (formpassword.valid() === true) {
            $("#countdown_val").val(countdown);
            $("#formpassword").submit();
        }
    });

    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            username: {
                required: true,
                email: true
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });
    var formpassword = $('#formpassword');
    formpassword.validate();


    show_message = function(message_text, message_type, message_timeout){
        if(message_timeout === undefined) {
            message_timeout = 5000;
        }
        yDiff = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
        yDiff = yDiff - 40;
        $('#message_container').html('<div id="message" style="top: '+yDiff+'px;z-index: 900;"><div class="alert alert-' + message_type + ' alert-styled-left">' +
            '<button type="button" class="close" data-dismiss="alert" style="margin-top:-3px"><span  style="font-size:1.8rem;font-weight:500">×</span><span class="sr-only">Close</span></button>'
            + message_text + '</div></div>');
        $('#message_container').show();
        setTimeout(function() {
            $('#message_container').fadeOut('slow');
        }, message_timeout);
    }

    function do_countdown(){
        if (countdown > 0){
            countdown = countdown - 1;
            $('#countdown').text("in " + countdown);
        } else {
            clearInterval(counter);
            $('#countdown').text("");
            $('#login_token_resend').prop('disabled',false);
        }
    }

    var counter = setInterval(do_countdown, 1000);


    $(document).on('click', '#login_token_resend', function (e) {
        e.preventDefault();

        countdown = 60;
        counter = setInterval(do_countdown, 1000);
        send_token();
    });

    function send_token(){
        var id = $('#sender').val();
        $('#login_token_resend').prop('disabled',true);
        var request = $.ajax({
            url: '/' + subdir + '/auth/send_token',
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                show_message("Your token has been sent to your registered email or phone number, please enter it below","success");
            } else {
                // hide_loading_message();
                show_message(output.message, 'warning');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            // hide_loading_message();
            show_message('Request failed, please try again in 60 seconds or contact support ', 'warning');
        });
    }

    show_message = function(message_text, message_type, message_timeout){
        if(message_timeout === undefined) {
            message_timeout = 5000;
        }
        yDiff = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
        yDiff = yDiff - 40;
        $('#message_container').html('<div id="message" style="top: '+yDiff+'px;z-index: 900;"><div class="alert alert-' + message_type + ' alert-styled-left">' +
            '<button type="button" class="close" data-dismiss="alert" style="margin-top:-3px"><span  style="font-size:1.8rem;font-weight:500">×</span><span class="sr-only">Close</span></button>'
            + message_text + '</div></div>');
        $('#message_container').show();
        setTimeout(function() {
            $('#message_container').fadeOut('slow');
        }, message_timeout);
    }

    setTimeout(function() {
        $('#message_container').fadeOut('slow');
    }, 5000);


    setTimeout(function () {
        $('.alert').fadeOut('slow');
    }, 4000);

});