$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];  //get subfolder (if any) that page is running from and page name

    var count_errors = 0;
    var framework_type = $('#framework_type').val();
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f'){
            framework_id = params[i + 1];
        }
    }



    window.onscroll = function () {
        scrollFunction()
    };

    function scrollFunction() {
        if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
            document.getElementById("go_to_top").style.display = "block";
        } else {
            document.getElementById("go_to_top").style.display = "none";
        }
    }
    $(document).on('click', '#go_to_top', function () {
        document.body.scrollTop = 0; // For Safari
        document.documentElement.scrollTop = 0; // For Chrome, Firefox, IE and Opera
    });


    // Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

    // Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }


    $('#drop').change(function () {
        $('#selectparticipant option:selected').val(0);
        refreshParticipantList();
        refreshHeaderInfo(true);
    });


    //hide search option for yes/no drop downs
    $('#showcancelled').select2({
        minimumResultsForSearch: -1
    });
    $('#activetype').select2({
        minimumResultsForSearch: -1
    });
    $('#showrejected').select2({
        minimumResultsForSearch: -1
    });

    $(".select2-selection--single").each(function () {
        $(this).addClass("border-primary text-primary-700");
    });

    function refreshParticipantList() {
        var round = $('#drop option:selected').val();
        var request = $.ajax({
            url: '/' + subdir + '/participant_round_display/get_participants/f/' + framework_id,
            data: 'selectedround=' + round + '&openroundsonly=0',
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                var html = "<option value=\"0\" selected=\"selected\">All</option>";
                $.each(output.data, function (key, val) {
                    html += "<option value=" + val["id"] + ">" + val["fname"] + " " + val["lname"] + "</option>";

                });
                $('#selectparticipant').html(html);

            } else {
                // show_message('Information request failed', 'warning');
            }
        });
    }


    $(document).on('click', '#function_edit_nominations', function(e){
        e.preventDefault();
        $('.ui-tooltip').remove();
        var survey_url = $(this).data('survey_url');
        window.open(survey_url,'_blank');
    });

    $(document).on('click', '#function_edit_survey', function(e){
        e.preventDefault();
        $('.ui-tooltip').remove();
        var survey_url = $(this).data('survey_url');
        window.open(survey_url,'_blank');
    });

    $(document).on('click', '#function_copy_survey_url', function(e){
        e.preventDefault();
        $('.ui-tooltip').remove();
        var survey_url = $(this).data('survey_url');
        var name = $(this).data('name');
        copyToClipboard(survey_url);
        alert("Survey URL for " + name + " copied to clipboard.");
    });

    function copyToClipboard(text){
        var dummy = document.createElement("input");
        document.body.appendChild(dummy);
        dummy.setAttribute('value', text);
        dummy.select();
        document.execCommand("copy");
        document.body.removeChild(dummy);
    }



    // go to participant status
    $(document).on('click', '.function_edit_raters a', function (e) {
        e.preventDefault();
        var partid = $(this).data('id');
        var round_id = $(this).data('round_id');
        window.location = '/' + subdir + '/manage_respondents/f/' + framework_id + '/round_id/' + round_id + '/participant_id/' + partid;
    });


    function refreshHeaderInfo(animate) {
        var round = $('#drop option:selected').val();
        var selectparticipant = $('#selectparticipant option:selected').val();
        var request = $.ajax({
            url: '/' + subdir + '/survey/get_completions/f/' + framework_id,
            cache: false,
            data: 'selectedround=' + round + '&selectedparticipant='+selectparticipant,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                var resp_perc = 0;
                var part_perc_a = 0;
                var part_perc_b = 0;

                var part_string_a = output.data['completed_part_a'] + '/' + output.data['total_part'];
                if (output.data['total_part'] > 0)  part_perc_a = output.data['completed_part_a'] / output.data['total_part'];
                var part_string_b = output.data['completed_part_b'] + '/' + output.data['total_part'];
                if (output.data['total_part'] > 0)  part_perc_b = output.data['completed_part_b'] / output.data['total_part'];
                var resp_string = output.data['completed_resp'] + '/' + output.data['total_resp'];
                if (output.data['total_resp'] > 0) resp_perc = output.data['completed_resp'] / output.data['total_resp'];

                progressCounter('#participants_incomplete', 38, 6, "#039BE5", part_perc_a, "icon-user-plus text-blue-600", 'Partially Completed', part_string_a, 32, animate);

                progressCounter('#participants_complete', 38, 6, "#00ACC1", part_perc_b, "icon-user-check text-info-600", 'Completed Surveys', part_string_b, 32, animate);
            } else {
                //
            }
        });
    }

    refreshHeaderInfo(true);

    var header_t = setInterval(function () {
            //don't animate on update
            refreshHeaderInfo(false);
        },
        120000);

    // Chart setup
    function progressCounter(element, radius, border, color, end, iconClass, textTitle, textTotal, iconWidth, animate) {


        // Basic setup
        // ------------------------------

        $(element).html('');
        var start = 0;

        if (!animate) {
            start = end;
        }
        // Main variables
        var d3Container = d3.select(element),
            startPercent = start,
            endPercent = end,
            iconSize = 32,
            twoPi = Math.PI * 2,
            formatPercent = d3.format('.0%'),
            boxSize = radius * 2;

        // Values count
        var count = Math.abs((endPercent - startPercent) / 0.01);

        // Values step
        var step = endPercent < startPercent ? -0.01 : 0.01;


        // Create chart
        // ------------------------------

        // Add SVG element
        var container = d3Container.append('svg');

        // Add SVG group
        var svg = container
            .attr('width', boxSize)
            .attr('height', boxSize)
            .append('g')
            .attr('transform', 'translate(' + (boxSize / 2) + ',' + (boxSize / 2) + ')');


        // Construct chart layout
        // ------------------------------

        // Arc
        var arc = d3.svg.arc()
            .startAngle(0)
            .innerRadius(radius)
            .outerRadius(radius - border);


        //
        // Append chart elements
        //

        // Paths
        // ------------------------------

        // Background path
        svg.append('path')
            .attr('class', 'd3-progress-background')
            .attr('d', arc.endAngle(twoPi))
            .style('fill', '#eee');

        // Foreground path
        var foreground = svg.append('path')
            .attr('class', 'd3-progress-foreground')
            .attr('filter', 'url(#blur)')
            .style('fill', color)
            .style('stroke', color);

        // Front path
        var front = svg.append('path')
            .attr('class', 'd3-progress-front')
            .style('fill', color)
            .style('fill-opacity', 1);


        // Text
        // ------------------------------

        // Percentage text value
        var numberText = d3.select(element)
            .append('h2')
            .attr('class', 'mt-15 mb-5')

        // Icon
        d3.select(element)
            .append("i")
            .attr("class", iconClass + " counter-icon")
            .attr('style', 'top: ' + ((boxSize - iconSize) / 2) + 'px; margin-left: ' + (18 - (iconWidth)) + 'px');

        // Title
        d3.select(element)
            .append('div')
            .text(textTitle);

        // Subtitle
        d3.select(element)
            .append('div')
            .attr('class', 'text-size-small text-muted')
            .text(textTotal);


        // Animation
        // ------------------------------

        // Animate path
        function updateProgress(progress) {
            foreground.attr('d', arc.endAngle(twoPi * progress));
            front.attr('d', arc.endAngle(twoPi * progress));
            numberText.text(formatPercent(progress));
        }

        // Animate text
        var progress = startPercent;
        (function loops() {
            updateProgress(progress);
            if (count > 0) {
                count--;
                progress += step;
                setTimeout(loops, 10);
            }
        })();
    }


    $(document).click(function() {
        $('.ui-tooltip').remove();
    });


});
