$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];  //get subfolder (if any) that page is running from and page name
    var table_reports;
    var table_reports_id = "";
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f'){
            framework_id = params[i + 1];
        }
    }


    if ($('#table_reports').length) {
        table_reports_id = "table_reports";
        table_reports = $('#table_reports').DataTable({
            //"ajax": "./includes/reportdata.php?job=get_participants",
            'ajax': {
                "type": "POST",
                "url": '/' + subdir + '/report/get_reports/f/' + framework_id,
                "data": function (d) {
                    d.activetype = $('#activetype option:selected').val(); // $('#activeonlyyes').is(':checked');
                    d.selectedround = $('#drop option:selected').val();
                    d.csrf_token = $('meta[name="csrf-token"]').attr('content');
                }
            },
            "columns": [
                {"data": "id"},
                {"data": "round_id"},
                {"data": "report_name"},
                {"data": "file_output"},
                {"data": "schedule_date"},
                {"data": "round_name"},
                {"data": "status"},
                {"data": "functions", "sClass": "functions"}
            ],
            "order": [],
            "aaSorting": [],
            "buttons": [{
                "extend": 'copy',
                "exportOptions": {
                    "columns": ':visible'
                }
            },
                {
                    "extend": 'print',
                    "exportOptions": {
                        "columns": ':visible'
                    }
                },
                {
                    "extend": 'excel',
                    "exportOptions": {
                        "columns": ':visible'
                    }
                }],
            "aoColumnDefs": [
                {"bSortable": false, "aTargets": [-1]},
                {
                    "aTargets": [0, 1],
                    "bVisible": false,
                    "bSearchable": false
                }
            ],
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "oLanguage": {
                "oPaginate": {
                    "sFirst": " ",
                    "sPrevious": " ",
                    "sNext": " ",
                    "sLast": " ",
                },
                "sLengthMenu": "Records per page: _MENU_",
                "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
                "sInfoFiltered": "(filtered from _MAX_ total records)"
            },
            "initComplete": function (settings, json) {
                table_reports.buttons().container().insertBefore('#table_reports_info');
                table_reports.buttons().container().css("float", "right");
            }
        });
    }

    t1 = setInterval(function () {
        $('#table_reports').DataTable().ajax.reload(null, false);
    }, 30000);

    // Cancel participant (make round = -1)
    $(document).on('click', '.function_cancel a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var report_name = $(this).data('name');
        var id = $(this).data('id');
        var round_id = $('#drop option:selected').val();

        $.when(confirm_request("Are you sure you want to cancel '" + report_name + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/report/cancel_report/f/' + framework_id,
                        cache: false,
                        dataType: 'json',
                        data: {
                            round_id: round_id,
                            id: id,
                            name: report_name,
                            csrf_token: $('meta[name="csrf-token"]').attr('content')
                        },
                        // contentType: 'application/json; charset=utf-8',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            $('#table_reports').DataTable().ajax.reload(function () {
                                //hide_loading_message();
                                show_message("Report '" + report_name + "' cancelled successfully.", 'success');
                            }, true);
                        } else {
                            //hide_loading_message();
                            show_message('Cancel request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Cancel request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });

    /*
     * ERROR HANDLING
     */

    $.fn.dataTable.ext.errMode = 'none';

    $('#table_reports')
        .on('error.dt', function (e, settings, techNote, message) {
            console.log('An error has been reported by DataTables: ', message);
        })
        .DataTable();


    // On page load: form validation
    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            fiscal_year: {
                required: true,
                min: 2000,
                max: 2025
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });
    var form_participant = $('#form_participant');
    form_participant.validate();


    // Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

    // Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

    // Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

    // Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768){
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
            yloc = yloc - 40;
            $('.lightbox_container').css('top',yloc+'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
        $('.lightbox_container').scrollTop(0);
    }

    // Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

    // Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
    // Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
    // Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

    // Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }

    var downloading = false;

    $(document).on('click', '.function_download a', function (e) {
        downloading = true;
        $('.ui-tooltip').remove();
        show_loading_message();
        $("#file_output").val($(this).data('file_output'));
        $("#rep_round_id").val($(this).data('round_id'));
        $("#id").val($(this).data('id'));
        $("#form").submit();
        setTimeout(function() {
            downloading = false;
        }, 800);
        setTimeout(function() {
            hide_loading_message();
        }, 2000);
    });

    // window.onblur = function(){
    //     hide_loading_message();
    // };

    // window.onclick = function(){
    //     if (!downloading) hide_loading_message();
    // };

    //tooltips for tables
    $('[data-toggle="tooltip"]').tooltip({});

    //initialise hidden form value
    $('#round_id').val($('#drop').val());
    $('#drop').change(function () {
        $('#table_reports').DataTable().ajax.reload(null, true);
        refreshParticipantList();
        $('#round_id').val($(this).val());
    });

    $('#activetype').change(function () {
        $('#' + table_reports_id).DataTable().ajax.reload(null, true);
    });

    $('#showcancelled').change(function () {
        $('#table_reports').DataTable().ajax.reload(null, true);
    });


    //hide search option for yes/no drop downs
    $('#showcancelled').select2({
        minimumResultsForSearch: -1
    });

    setTimeout(function () {
        $('.alert').fadeOut('slow');
    }, 5000);

    function refreshParticipantList() {
        var $round = $('#drop option:selected').val();
        var request = $.ajax({
            url: '/' + subdir + '/participant_round_display/get_participant_list/f/' + framework_id,
            cache: false,
            data: 'selectedRound=' + $round,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                var html = "<option value=\"0\" selected=\"selected\">Select Participant</option>";
                $.each(output.data[0].participants, function (key, val) {
                    html += "<option value=" + val["id"] + ">" + val["fname"] + " " + val["lname"] + "</option>";

                });
                $('#selectparticipant').html(html);

            } else {
                // show_message('Information request failed', 'warning');
            }
        });
    }

    var report_counter = 0;

    // Report request submit form
    $(document).on('submit', '#requestForm', function (e) {
        e.preventDefault();

        // Send respondent information to database
        show_loading_message();
        var form_data = $('#requestForm').serialize();
        var csrf_token = $('meta[name="csrf-token"]').attr('content');
        var request = $.ajax({
            url: '/' + subdir + '/report/request_report/f/' + framework_id,
            cache: false,
            data: form_data + '&' + $.param({'csrf_token': csrf_token}),
            dataType: 'json',
            // contentType: 'application/json; charset=utf-8',
            type: 'POST'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                // Reload datable
                $('#table_reports').DataTable().ajax.reload(function () {
                }, false);
                show_message(output.message, 'success');
                generate_next_report();  //call only if running reports on same server
            } else {
                show_message(output.message, 'danger');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Request failed: ' + textStatus, 'danger');
        });
        hide_loading_message();

    });

    function generate_next_report(){
        show_loading_message();
        var csrf_token = $('meta[name="csrf-token"]').attr('content');
        var request = $.ajax({
            url: '/' + subdir + '/report/run_reports/f/' + framework_id,
            cache: false,
            data: $.param({'csrf_token': csrf_token}) + '&' + $.param({'framework_id': framework_id}),
            dataType: 'json',
            // contentType: 'application/json; charset=utf-8',
            type: 'POST'
        });
        request.done(function (output) {
            if (output.result == 'continue' && report_counter < 5) {
                // Reload datable
                $('#table_reports').DataTable().ajax.reload(function () {
                }, false);
                report_counter++;
                // console.log(report_counter);
                generate_next_report();
            } else if (output.result == 'done') {
                $('#table_reports').DataTable().ajax.reload(function () {
                }, false);
                hide_loading_message();
                report_counter = 0;
                // show_message(output.message, 'danger');
            } else {
                hide_loading_message();
                report_counter = 0;
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            $('#table_reports').DataTable().ajax.reload(function () {
            }, false);
            // show_message('Request failed: ' + textStatus, 'danger');
        });
    }

});
