$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var thisdir = params[1] + '/' + params[2];  //get subfolder (if any) that page is running from and page name
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f'){
            framework_id = params[i + 1];
        }
    }

    /*
     * ERROR HANDLING
     */

    $.fn.dataTable.ext.errMode = 'none';

    $('#table_frameworks')
        .on('error.dt', function (e, settings, techNote, message) {
            console.log('An error has been reported by DataTables: ', message);
        })
        .DataTable();


// On page load: form validation
    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            uname: {
                required: true,
                //checkUserName: true
            },
            password: {
                minlength: 3
            },
            confirm_password: {
                minlength: 3,
                equalTo: "#password"
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });

    //manually fade out alert (from bulk import)
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 3000);

// Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

// Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

// Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

// Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768){
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
            yloc = yloc - 40;
            $('.lightbox_container').css('top',yloc+'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
        $('.lightbox_container').scrollTop(0);
    }

// Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

// Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
// Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
// Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

// Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }



    var table_cron_jobs = $('#table_cron_jobs').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/framework/get_cron_jobs/f/' + framework_id,
            "data": function (d) {
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "name"},
            {"data": "path"},
            {"data": "schedule"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });


// Add cron button
    $(document).on('click', '.function_add_cron a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/framework/get_cron_jobs/f/' + framework_id,
            cache: false,
            data: $.param({'id': id}) + '&' + $.param({'csrf_token':  $('meta[name="csrf-token"]').attr('content')}),
            type: 'POST'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('#form_framework').hide();
                $('#form_survey').hide();
                $('#form_reports').hide();
                $('#form_resp_attributes').hide();
                $('#form_question_codes').hide();
                $('#form_cron_jobs').show();
                $('.lightbox_content h2').text('Add Cron Schedule');
                $('#form_cron_jobs button').html('Add Cron Schedule <i class="icon-arrow-right14 position-right"></i>');
                $('#form_cron_jobs').attr('class', 'form add');
                $('#form_cron_jobs').attr('data-id', id);
                $('#form_cron_jobs .field_container label.error').hide();
                $('#form_cron_jobs .field_container').removeClass('valid').removeClass('error');
                $('#form_cron_jobs #cron_schedule').val('* * * * *');
                $('#form_cron_jobs #cron_name').val(output.data[0]['name']);
                $('#form_cron_jobs #cron_path').val(output.data[0]['path']);
                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed 1', 'warning');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed 2: ' + textStatus, 'warning');
        });
    });

// Add resp attribute submit form
    $(document).on('submit', '#form_cron_jobs.add', function (e) {
        e.preventDefault();
        // Validate form
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_cron_jobs').attr('data-id');
            var form_data = $('#form_cron_jobs').serialize();
            var request = $.ajax({
                url: '/' + subdir + '/framework/add_cron_job/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'id': id}) + '&' + $.param({'csrf_token':  $('meta[name="csrf-token"]').attr('content')}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message("Cron added successfully", 'success');
                    $('#table_cron_jobs').DataTable().ajax.reload(function () {
                    }, true);
                    update_cron_list();
                } else {
                    hide_loading_message();
                    show_message(output.result, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });

    });

// Edit resp attributes button
    $(document).on('click', '.function_edit_cron a', function (e) {
        e.preventDefault();
        // Get company information from database
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/framework/get_cron_jobs/f/' + framework_id,
            cache: false,
            data: $.param({'id': id}) + '&' + $.param({'csrf_token':  $('meta[name="csrf-token"]').attr('content')}),
            type: 'POST'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('#form_framework').hide();
                $('#form_survey').hide();
                $('#form_reports').hide();
                $('#form_resp_attributes').hide();
                $('#form_question_codes').hide();
                $('#form_cron_jobs').show();
                $('.lightbox_content h2').text('Edit Cron Schedule');
                $('#form_cron_jobs button').html('Edit Cron Schedule <i class="icon-arrow-right14 position-right"></i>');
                $('#form_cron_jobs').attr('class', 'form add');
                $('#form_cron_jobs').attr('data-id', id);
                $('#form_cron_jobs .field_container label.error').hide();
                $('#form_cron_jobs .field_container').removeClass('valid').removeClass('error');
                $('#form_cron_jobs #cron_schedule').val(output.data[0]['schedule']);
                $('#form_cron_jobs #cron_name').val(output.data[0]['name']);
                $('#form_cron_jobs #cron_path').val(output.data[0]['path']);
                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

// Edit survey submit form
    $(document).on('submit', '#form_cron.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_question_codes.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_cron_jobs').attr('data-id');
            var form_data = $('#form_cron_jobs').serialize();
            var request = $.ajax({
                url: '/' + subdir + '/framework/edit_cron_job/f/' + framework_id,
                cache: false,
                // data: form_data + '&id=' + id + '&framework_id=' + $('#framework option:selected').val(),
                data: form_data + '&' + $.param({'id': id}) + '&' + $.param({'csrf_token':  $('meta[name="csrf-token"]').attr('content')}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message("Cron edited successfully.", 'success');
                    $('#table_cron_jobs').DataTable().ajax.reload(function () {
                    }, false);
                    update_cron_list();
                } else {
                    hide_loading_message();
                    show_message('Edit request failed: ' + output['message'], 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

//delete question code
    $(document).on('click', '.function_delete_cron a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var code = $(this).data('name');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to delete '" + code + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/framework/delete_cron_job/f/' + framework_id,
                        cache: false,
                        // data: $.param({'id': id}) + '&' + $.param({'code': code}) + '&' + $.param({'csrf_token': csrf_token}) + '&' + $.param({'framework_id': $('#framework option:selected').val()}),
                        data: {
                            id: id,
                            code: code,
                            csrf_token: csrf_token,
                            framework_id: $('#framework option:selected').val()
                        },
                        dataType: 'json',
                        // contentType: 'application/json; charset=utf-8',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            show_message("'" + code + "' deleted successfully.", 'success');
                            $('#table_cron_jobs').DataTable().ajax.reload(function () {
                            }, false);
                            update_cron_list();
                        } else {
                            //hide_loading_message();
                            show_message('Cancel request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Cancel request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });

    update_cron_list();

    function update_cron_list(){
        $.ajax({
            url: '/' + subdir + '/framework/update_cron_list/f/' + framework_id,
            data: {'csrf_token': $('meta[name="csrf-token"]').attr('content')},
            dataType: 'html',
            type: "POST",
            success: function (output) {
                $('#cron_list').html(output);
            }
        });
    }

});
