$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];  //get subfolder (if any) that page is running from and page name
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f') {
            framework_id = params[i + 1];
        }
    }

    load_admin();

// On page load: form validation
    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            uname: {
                required: true,
            },
            current_password: {
                required: {
                    depends: isPasswordRequired,
                    param: true
                }
            },
            password: {
                is_pw_strong: {
                    depends: isPasswordRequired,
                    param: true
                }
            },
            confirm_password: {
                equalTo: "#password"
            },
            mobile: {
                required: function () {
                    if ($('#mfa_sms').val() == 1 && $('#use_mfa').val() == 1) {
                        return true;
                    }
                    else {
                        return false;
                    }
                }
            },
            email: {
                required: function () {
                    if (($('#mfa_sms').val() == 0 && $('#use_mfa').val() == 1)) {
                        return true;
                    }
                    else {
                        return false;
                    }
                },
                email: true
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            if ($(element).attr("name") == "current_password")
                $(element).parent('.field_container').removeClass('error');
            else
                $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });

    $("#password").complexify({
            minimumChars: $('#pwl').val(),
            banMode: 'strict',
            strengthScaleFactor: $('#pwf').val(),
            bannedPasswords: custom_arr()
        },
        function (valid, complexity) {
            // Show percentage
            var outputstr = "";
            var cp = Math.round(complexity);
            if (cp < $('#pws').val()) {
                var strength = '<span style="color:darkorange"><strong>Strength: ' + cp + '</strong></span>';
            } else {
                var strength = '<span style="color:green"><strong>Strength: ' + cp + '</strong></span>';
            }
            var length = $("#password").val().length;
            if (length < $('#pwl').val()) {
                var lenstr = '<span style="color:darkorange"><strong>Length: ' + length + '</strong></span>';
            } else {
                var lenstr = '<span style="color:green"><strong>Length: ' + length + '</strong></span>';
            }
            outputstr = strength + '; ' + lenstr;
            $('#pw_strength').html(outputstr);
        }
    );
    function custom_arr(){
        if ($('#pwacw').val() == 1){
            var arr = [];
        } else {
            var arr = window.COMPLEXIFY_BANLIST;
        }
        arr.push($('#uname').val());
        arr.push($('#l_name').val());
        arr.push($('#f_name').val());
        return arr;
    }

    var checkmsg = "";
    $.validator.addMethod("pwcheck", function (value) {
        var output = check_password(true);
        var data = output.data;
        if (data != "") {
            return false;
        } else {
            return true;
        }
    }, function (params, element) {
        return 'Please meet all password criteria below'; // checkmsg;
    });

    $.validator.addMethod("is_pw_strong", function (value) {
        var score;
        $("#password").complexify({
                minimumChars: $('#pwl').val(),
                banMode: 'strict',
                strengthScaleFactor: $('#pwf').val(),
                bannedPasswords: custom_arr()
            },
            function (valid, complexity) { //show de password level
                // Show percentage
                score = complexity;
            }
        );
        if (score < $('#pws').val() || $("#password").val().length < $('#pwl').val()) {
            return false;
        } else {
            return true;
        }
    }, function (params, element) {
        return 'Choose a strong password of at least '+$('#pwl').val()+' characters, containing no common words and a mix of letters, numbers and symbols'; // checkmsg;
    });

    function isPasswordRequired() {
        var check = true;
        //if form is edit AND password blank then is not required, otherwise (if form is add, OR form is edit and length > 0) it is required
        if ($("#form_admin").hasClass("edit") && $('#password').val().length == 0) check = false;
        return check;
    }

    var form_admin = $('#form_admin');
    form_admin.validate();

// Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

// Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

// Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

// Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768) {
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset);
            yloc = yloc - 40;
            $('.lightbox_container').css('top', yloc + 'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
        $('.lightbox_container').scrollTop(0);
    }

// Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

// Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
// Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });

    // $(document).on('keyup', '#password', function () {
    //     var pw = $('#password').val();
    //     var length = pw.length;
    //     var result;
    //     if (length >0){
    //         $.ajax({
    //             url: '/' + subdir + '/auth/pw_strength/f/' + framework_id,
    //             type: "POST",
    //             data: {
    //                 pw: pw,
    //                 submit: false,
    //                 csrf_token: $('meta[name="csrf-token"]').attr('content')
    //             },
    //             dataType: "json",
    //             success: function (output) {
    //                 if (length > 0) {
    //                     var data = output.data;
    //                     if (data != ""){
    //                         var outputstr = '<span style="color:darkorange"><strong>' + data + '</strong></span>';
    //                     } else {
    //                         var outputstr = '<span style="color:green"><strong>OK</strong></span>';
    //                     }
    //
    //                     $('#pw_strength').html(outputstr);
    //                 } else {
    //                     $('#pw_strength').html("");
    //                 }
    //             }
    //         });
    //     } else {
    //         $('#pw_strength').html("");
    //     }
    // });

    function check_password(from_submit) {
        var pw = $('#password').val();
        var result;
        $.ajax({
            url: '/' + subdir + '/auth/pw_strength/f/' + framework_id,
            type: "POST",
            async: false,
            data: {
                pw: pw,
                submit: from_submit,
                csrf_token: $('meta[name="csrf-token"]').attr('content')
            },
            dataType: "json",
            success: function (output) {
                result = output;
            }
        });
        return result;
    }


// Escape keyboard key
//     $(document).keyup(function (e) {
//         if (e.keyCode == 27) {
//             hide_lightbox();
//         }
//     });

// Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }

    function load_admin() {
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/admin/get_admin/f/' + framework_id,
            cache: false,
            data: 'admin_edit=1',
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('#form_admin').attr('class', 'form edit');
                $('#form_admin').attr('data-id', id);
                $('#form_admin').attr('data-name', output.data[0].fname + ' ' + output.data[0].lname);
                $('#form_admin .field_container label.error').hide();
                $('#form_admin .field_container').removeClass('valid').removeClass('error');
                $('#form_admin #uname').val(output.data[0].uname);
                $('#form_admin #fname').val(output.data[0].fname);
                $('#form_admin #lname').val(output.data[0].lname);
                $('#form_admin #password').attr('required', false);
                $('#form_admin #confirm_password').attr('required', false);
                $('#form_admin #confirm_password').val('');
                $('#form_admin #password').val('');
                $('#lblpwd').html('Password: <br />(leave blank to leave unchanged)');
                $('#lblconfpwd').html('Confirm Password: <br />(leave blank to leave unchanged)');

                $('#form_admin #use_mfa').val(output.data[0].use_mfa);

                if (output.data[0].use_mfa == 0) {
                    $('#mfa_settings').hide();
                } else $('#mfa_settings').show();

                if (output.data[0].mobile == '' || output.data[0].mobile == null) {
                    $('#form_admin #mfa_sms').val(0);
                } else {
                    $('#form_admin #mfa_sms').val(1);
                    $('#form_admin #sms_settings').show();
                }

                $('#form_admin #mobile').val(output.data[0].mobile);
                $('#form_admin #email').val(output.data[0].email);

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    }

    $(document).on('click', '.function_edit a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/admin/get_admin/f/' + framework_id,
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                // var framework_id = output.data[0].framework_id;
                $('.lightbox_content h2').text('Edit Administrator');
                $('#form_admin button').html('Edit Administrator <i class="icon-arrow-right14 position-right"></i>');
                $('#form_admin').attr('class', 'form edit');
                $('#form_admin').attr('data-id', id);
                $('#form_admin').attr('data-name', output.data[0].fname + ' ' + output.data[0].lname);
                $('#form_admin .field_container label.error').hide();
                $('#form_admin .field_container').removeClass('valid').removeClass('error');
                $('#form_admin #uname').val(output.data[0].uname);
                $('#form_admin #fname').val(output.data[0].fname);
                $('#form_admin #lname').val(output.data[0].lname);
                $('#form_admin #password').attr('required', false);
                $('#form_admin #confirm_password').attr('required', false);
                $('#form_admin #confirm_password').val('');
                $('#form_admin #password').val('');
                $('#lblpwd').html('Password: <br />(leave blank to leave unchanged)');
                $('#lblconfpwd').html('Confirm Password: <br />(leave blank to leave unchanged)');
                $('#form_admin #frameworks').empty();

                $('#form_admin #use_mfa').val(output.data[0].use_mfa);

                if (output.data[0].use_mfa == 0) {
                    $('#mfa_settings').hide();
                } else $('#mfa_settings').show();

                if (output.data[0].mobile == '' || output.data[0].mobile == null) {
                    $('#form_admin #mfa_sms').val(0);
                } else {
                    $('#form_admin #mfa_sms').val(1);
                    $('#sms_settings').show();
                }

                $('#form_admin #mobile').val(output.data[0].mobile);
                $('#form_admin #email').val(output.data[0].email);

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

    $(document).on('submit', '#form_admin.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_admin.valid() == true) {
            if ($('#form_admin').attr('data-currentstatus') == "1" && $('#form_admin #active').val() == 0 && !confirm("Are you sure you want to cancel '" + $('#form_admin').attr('data-name') + "?")) {
                return;
            }
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_admin').attr('data-id');
            var form_data = $('#form_admin').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var myFrameworks = new Array();
            $("input:checked").each(function () {
                myFrameworks.push($(this).val());
            });
            var json_arr = JSON.stringify(myFrameworks);
            var request = $.ajax({
                url: '/' + subdir + '/admin/edit_admin/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'id': id}) + '&' + $.param({'from_account_settings': true}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    hide_loading_message();
                    $('#admin_name_nav').text($('#form_admin #fname').val() + ' ' + $('#form_admin #lname').val());
                    $('#form_admin #current_password').val("");
                    $('#form_admin #confirm_password').val("");
                    $('#form_admin #password').val("");
                    $('#form_admin #pw_strength').html("");
                    $('.field_container').removeClass('valid');
                    show_message('Account edited successfully', 'success');
                } else {
                    hide_loading_message();
                    show_message('Edit request failed: ' + output['message'], 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

    $('[data-toggle="tooltip"]').tooltip({});

    $('#use_mfa').change(function () {
        if ($('#use_mfa').val() == 0) {
            $('#mfa_settings').hide();
        } else {
            $('#mfa_settings').show();
        }
    });

    if ($('#use_mfa').val() == 1) {
        $('#mfa_settings').show();
    } else {
        $('#mfa_settings').hide();
    }

    $('#mfa_sms').change(function () {
        if ($('#mfa_sms').val() == 0) {
            $('#sms_settings').hide();
        } else {
            $('#sms_settings').show();
        }
    });

    if ($('#mfa_sms').val() == 0) {
        $('#sms_settings').hide();
    } else {
        $('#sms_settings').show();
    }
});
